CREATE PROCEDURE ais.GetRegistry(@DatBeg DATE, @DatEnd DATE, @TimeMark DATETIME, @RecCount INT, @QTimeMark BIGINT)
AS 

	SELECT TOP (@RecCount)
				tbl.TF_UIDIDSL,
				tbl.TF_GKEY,
				tbl.TIME_MARK AS LastDtChange,
				tbl.OT_PER,
				tbl.MSK_OT,
				tbl.CODE_MSK,
				tbl.VID_MP,
				tbl.USL_OK,
				tbl.PROFIL,
				tbl.MKB1,
				tbl.MKB2,
				tbl.MKB3,
				tbl.CODE_USL,
				tbl.CODE_MD,
				tbl.KOL_USL,
				tbl.KOL_FACT,
				tbl.ISH_MOV,
				tbl.RES_GOSP,
				tbl.TARIF_B,
				tbl.TARIF_S,
				tbl.TARIF_1K,
				tbl.SUM_RUB,
				tbl.VID_TR,
				tbl.EXTR,
				tbl.CODE_OTD,
				tbl.SOUF,
				tbl.SPEC_MD,
				tbl.DOMC_TYPE,
				tbl.OKATO_INS,
				tbl.NOVOR,
				tbl.CODE_LPU,
				tbl.VID_SF,
				tbl.NHISTORY,
				tbl.PERSCODE,
				tbl.DATE_IN,
				tbl.DATE_OUT,
				tbl.TARIF_D,
				tbl.VID_KOEFF,
				tbl.USL_TMP,
				tbl.BIRTHDAY,
				tbl.SEX,
				tbl.COUNTRY,
				tbl.SEX_P,
				tbl.BIRTHDAY_P,
				tbl.INV,
				tbl.DATE_NPR,
				tbl.FOR_POM,
				tbl.MSE,
				tbl.P_CEL,
				tbl.DN,
				tbl.TAL_P,
				tbl.PROFIL_K,
				tbl.NAPR_MO,
				tbl.MKB0,
				tbl.DS_ONK,
				tbl.VAL_KOEFF,
				tbl.C_ZAB,
				tbl.EKMP,
				tbl.MEE
	FROM (
			select r.*
			from  r
				LEFT JOIN [ais].HistorySyncData hsd WITH(NOLOCK)
				ON r.RE_MU_ID = hsd.TF_UIDIDSL								-- id-
					AND ISNULL(r.RE_UO_ID, r.RE_MU_ID) = hsd.TF_GKEY		-- id-
					AND r.TIME_MARK = hsd.LastDtChange
			where r. between @DatBeg and @DatEnd
				AND r.TIME_MARK >= @TimeMark
				AND hsd.HistorySyncData_Id IS NULL							--     
		) AS tbl
	ORDER BY tbl.TIME_MARK

GO